/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.textfield;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class VWNumericTextFieldDocument
extends PlainDocument {
    private int m_width = 0;
    private boolean m_bAllowNegative = true;
    private int m_decimalDigitCount = 0;
    private DecimalFormat m_decimalFormat = null;
    private static Locale s_locale = Locale.getDefault();
    private static DecimalFormatSymbols s_decimalFormatSymbols = new DecimalFormatSymbols(s_locale);
    private static NumberFormat s_numberFormat = NumberFormat.getInstance(s_locale);
    private static char s_minusSign = s_decimalFormatSymbols.getMinusSign();
    private static char s_demicalPoint = s_decimalFormatSymbols.getDecimalSeparator();

    VWNumericTextFieldDocument() {
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    void setDecimalDigitCount(int count) {
        this.m_decimalDigitCount = count;
        if (this.m_decimalDigitCount > 0) {
            int i;
            String pattern = new String();
            for (i = 0; i < this.m_width; ++i) {
                pattern = pattern + "#";
            }
            pattern = pattern + "0.0";
            for (i = 0; i < this.m_decimalDigitCount - 1; ++i) {
                pattern = pattern + "#";
            }
            this.m_decimalFormat = new DecimalFormat(pattern, s_decimalFormatSymbols);
        }
    }

    void setAllowNegative(boolean bAllowNegative) {
        this.m_bAllowNegative = bAllowNegative;
    }

    boolean isLegal(String str, int offs, String inserts) {
        if (inserts == null || inserts.length() == 0) {
            return true;
        }
        int decimalDigitCount = 0;
        boolean intDigitCount = false;
        boolean bDecimalPoint = false;
        boolean bMinusSign = false;
        int length = 0;
        char[] s = null;
        if (str == null) {
            length = inserts.length();
            s = inserts.toCharArray();
        } else {
            length = str.length() + inserts.length();
            s = new char[length];
            int i = 0;
            int index = 0;
            while (i < str.length() && i < offs) {
                s[index] = str.charAt(i);
                ++i;
                ++index;
            }
            int j = 0;
            while (j < inserts.length()) {
                s[index] = inserts.charAt(j);
                ++j;
                ++index;
            }
            while (i < str.length()) {
                s[index] = str.charAt(i);
                ++i;
                ++index;
            }
        }
        int width = 0;
        for (int i = 0; i < length; ++i) {
            if (width >= this.m_width) {
                return false;
            }
            ++width;
            char c = s[i];
            if (c == s_minusSign) {
                if (!this.m_bAllowNegative) {
                    return false;
                }
                if (i != 0) {
                    return false;
                }
                bMinusSign = true;
                continue;
            }
            if (c == s_demicalPoint) {
                if (this.m_decimalDigitCount == 0) {
                    return false;
                }
                if (length - i - 1 > this.m_decimalDigitCount) {
                    return false;
                }
                bDecimalPoint = true;
                continue;
            }
            if (Character.isDigit(c)) {
                if (!bDecimalPoint) continue;
                if (decimalDigitCount < this.m_decimalDigitCount) {
                    ++decimalDigitCount;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    String toDecimalStr(String str) {
        if (str != null && str.length() > 0) {
            try {
                Number num = s_numberFormat.parse(str);
                if (this.m_decimalDigitCount > 0) {
                    str = this.m_decimalFormat.format(num);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return str;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        int length = this.getLength();
        String text = this.getText(0, length);
        String subString = null;
        if ((text == null || text.length() == 0) && offs == 0 && this.m_decimalDigitCount > 0 && str.length() > 1) {
            str = this.toDecimalStr(str);
        }
        for (int i = str.length(); i > 0; --i) {
            subString = str.substring(0, i);
            if (!this.isLegal(text, offs, subString)) continue;
            super.insertString(offs, subString, a);
            break;
        }
    }
}

